/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.event;

import azmalent.terraincognita.TIConfig;
import azmalent.terraincognita.common.block.plants.SmallLilypadBlock;
import azmalent.terraincognita.common.registry.ModBlocks;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.BonemealEvent;

public class BonemealHandler {
    private static final int MAX_LILYPAD_GROWING_DEPTH = 4;

    public static void registerListeners() {
        if (TIConfig.Misc.bonemealLilypadGrowing.get().booleanValue()) {
            MinecraftForge.EVENT_BUS.addListener(BonemealHandler::onBonemealUnderwater);
        }
    }

    private static boolean isInShallowWater(World world, BlockPos pos) {
        if (world.func_204610_c(pos.func_177984_a()).func_206886_c() != Fluids.field_204546_a) {
            return false;
        }
        for (int i = 2; i < 5; ++i) {
            if (world.func_204610_c(pos.func_177981_b(i)).func_206886_c() == Fluids.field_204546_a) continue;
            return world.func_175623_d(pos.func_177981_b(i));
        }
        return false;
    }

    private static void placeRandomLilypad(World world, BlockPos pos, boolean isJungle) {
        Random rand = world.func_201674_k();
        float f = rand.nextFloat();
        BlockState blockState = (double)f < 0.5 && isJungle && TIConfig.Flora.lotus.get() != false ? ModBlocks.LOTUSES.get(rand.nextInt(3)).getBlock().func_176223_P() : ((double)f < 0.5 && !isJungle && TIConfig.Flora.smallLilypad.get() != false ? (BlockState)ModBlocks.SMALL_LILY_PAD.getBlock().func_176223_P().func_206870_a((Property)SmallLilypadBlock.LILYPADS, (Comparable)Integer.valueOf(1 + rand.nextInt(4))) : Blocks.field_196651_dG.func_176223_P());
        world.func_175656_a(pos, blockState);
    }

    public static void onBonemealUnderwater(BonemealEvent event) {
        BlockPos pos;
        World world = event.getWorld();
        if (world.func_180495_p(pos = event.getPos()).func_177230_c() instanceof IGrowable) {
            return;
        }
        Biome.Category category = world.func_226691_t_(pos).func_201856_r();
        if (category != Biome.Category.SWAMP && category != Biome.Category.JUNGLE) {
            return;
        }
        if (BonemealHandler.isInShallowWater(world, pos)) {
            Random rand = world.func_201674_k();
            for (int i = 0; i < 4; ++i) {
                int z;
                int y;
                int x = rand.nextInt(4) - rand.nextInt(4);
                BlockPos lilypadPos = pos.func_177982_a(x, y = rand.nextInt(4) + 2, z = rand.nextInt(4) - rand.nextInt(4));
                if (!world.func_175623_d(lilypadPos) || world.func_204610_c(lilypadPos.func_177977_b()).func_206886_c() != Fluids.field_204546_a) continue;
                BonemealHandler.placeRandomLilypad(world, lilypadPos, category == Biome.Category.JUNGLE);
            }
        }
    }
}

